package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Stallion_chassis extends Stallion_models
{
	public Stallion_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Stallion";
		name = getName();
		
		rID_blueprint = cars.cat_03.Stallion:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_YELLOW;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 14962;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.352;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_03.Stallion:0x01DAr; //Left taillight dark
		parts_shop_sml[1] = cars.cat_03.Stallion:0x01EDr; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_03.Stallion:0x00FAr; //Left exhaust
		parts_shop_big[1] = cars.cat_03.Stallion:0x00F9r; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_03.stallion:0x000000D2r, "FR door", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000D4r, "RR window", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000D7r, "R door", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000D9r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000DAr, "L taillights", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000E1r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000E3r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000E5r, "RL window", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000E7r, "FL door", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000E8r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000E9r, "FR seat", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000EDr, "R taillights", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000EEr, "R seats", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000F9r, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_03.stallion:0x000000FAr, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D2r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D4r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D7r, "R door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D9r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000DAr, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E1r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E3r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E5r, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E7r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E8r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E9r, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000EDr, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000EEr, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000F9r, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000FAr, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D3r, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D5r, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000DBr, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000ECr, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_03.stallion:0x000000EFr, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_03.stallion:0x000000DCr, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_03.stallion:0x000000DBr, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_03.stallion:0x000000F0r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_03.stallion:0x000000DDr, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_03.stallion:0x000000D3r, "R bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_03.stallion:0x000000F1r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_03.stallion:0x000000DEr, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_03.stallion:0x000000D5r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_03.stallion:0x000000F4r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_03.stallion:0x000000EBr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_03.stallion:0x000000ECr, "R sideskirt", actcolor, optical, power );
		}

		addPart( cars.cat_03.stallion:0x000000F5r, "FL suspension" );
		addPart( cars.cat_03.stallion:0x000000F6r, "FR suspension" );
		addPart( cars.cat_03.stallion:0x000000F7r, "RL suspension" );
		addPart( cars.cat_03.stallion:0x000000F8r, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // Chromo //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 375-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000ACr, "wheel" );
					addPart( parts.wheels_combo:0x000000ACr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
				} else                             // 215-17F 255-17R Flat //
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Sparkler //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 375-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B8r, "wheel" );
					addPart( parts.wheels_combo:0x000000B8r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
				} else                             // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				}
			} else                // SI //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 375-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B5r, "wheel" );
					addPart( parts.wheels_combo:0x000000B5r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
				} else                             // 215-17F 255-17R Speed 6 //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
				}
			}
		}

		if ( power >= 1.6 ) // Bilstein pro racer //
		{
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
		} else
		if ( power >= 1.4 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.2 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.666 ) // H&R pro racer 58000 Nm 10" //
		{
			addPart( parts.running_gear:0x0000021Fr, "spring" );
			addPart( parts.running_gear:0x0000021Fr, "spring" );
			addPart( parts.running_gear:0x00000220r, "spring" );
			addPart( parts.running_gear:0x00000220r, "spring" );
		} else
		if ( power >= 1.333 ) // H&R aftermarket 36000 Nm 11" //
		{
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
		} else                // stock 32000Nm 12" //
		{
			addPart( parts.running_gear:0x0000021Dr, "spring" );
			addPart( parts.running_gear:0x0000021Dr, "spring" );
			addPart( parts.running_gear:0x0000021Er, "spring" );
			addPart( parts.running_gear:0x0000021Er, "spring" );
		}

		if ( power >= 1.4 ) // Baer carbon 12.5"F 13.0"R //
		{
			addPart( parts.running_gear:0x000000E2r, "FL brake" );
			addPart( parts.running_gear:0x000000E5r, "FR brake" );
			addPart( parts.running_gear:0x000000FAr, "RL brake" );
			addPart( parts.running_gear:0x000000FFr, "RR brake" );
		} else
		if ( power >= 1.2 ) // Baer grooved 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000147r, "FL brake" );
			addPart( parts.running_gear:0x00000149r, "FR brake" );
			addPart( parts.running_gear:0x0000014Cr, "RL brake" );
			addPart( parts.running_gear:0x0000014Er, "RR brake" );
		} else              // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		}

		if ( power >= 1.4 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else              // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		}

		int supercharged;
		float enginePow;

		if ( power >= 1.857 )
		{
			enginePow = (power-1.857)/0.142*2;
			addPart( parts.engines.V8:0x0000000Cr, "10.0L V8 engine", actcolor, optical, enginePow );
			
		} else
		if ( power >= 1.714 )
		{
			enginePow = (power-1.714)/0.142*2;
			addPart( parts.engines.V8:0x0000000Br, "8.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.571 ) 
		{
			enginePow = (power-1.571)/0.142*2;
			addPart( parts.engines.V8:0x0000000Ar, "6.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.428 ) 
		{
			enginePow = (power-1.428)/0.142*2;
			addPart( parts.engines.V8:0x00000009r, "5.7L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.285 )
		{
			enginePow = (power-1.285)/0.142*2;
			addPart( parts.engines.V8:0x00000008r, "5.0L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.142 ) addPart( parts.engines.V6:0x00000008r, "4.0L V6 engine", actcolor, optical, (power-1.142)/0.142*2 ); else
		if ( power >= 1 ) addPart( parts.engines.V6:0x00000007r, "3.3L V6 engine", actcolor, optical, (power-1)/0.142*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.V6:0x00000060r, "2.8L V6 engine", actcolor, optical, (1-power)/0.5*2 );

		if(enginePow >= 1.50) supercharged++; //EvilMcSheep: Or at least has the sc intake manifold, which brings the intake too high as well

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		if(!supercharged) //No hood fits, not adding hood 4 as something found at the dealer either
		{
			if ( optical <= 1.0 )
			{
				if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000D6r, "hood", actcolor, optical, power );
			} else
			{
				part_random = random();
				if ( optical-1 >= 0.66667 ) addPart( cars.cat_03.stallion:0x000000F3r, "hood 3", actcolor, optical, power ); else
				if ( optical-1 >= 0.33333 ) addPart( cars.cat_03.stallion:0x000000E0r, "hood 2", actcolor, optical, power ); else
				addPart( cars.cat_03.stallion:0x000000D6r, "hood", actcolor, optical, power );
			}
		}
		addPart( cars.cat_03.Stallion:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
